-- name: \\#0ef\\F.\\#0cf\\L.\\#0bf\\U.\\#09f\\D.\\#08f\\D\\#FF0\\ v2.0
-- incompatible: moveset 
-- description: \\#0ef\\F.\\#0cf\\L.\\#0bf\\U.\\#09f\\D.\\#08f\\D\\#FF0\\ v2.0\\#FFF\\ introduces \\#FFF\\three of the Nozzles from \\#0ef\\Super Mario Sunshine\\#fff\\ into\\#d00\\ Super Mario 64.\\#fff\\                                                          Artwork & Models Created by \\#F00\\Nintendo                                        \\#FFF\\Porting and Programming by \\#70f\\Clamsplayz                                        \\#FFF\\---Commands---                      /fludd debug (true or false)        /fludd renders (true or false)
function convert_s16(num)
    local min = -32768
    local max = 32767
    while (num < min) do num = max + (num - min) end
    while (num > max) do num = min + (num - max) end
    return num
end

function s16(x)
    x = (math.floor(x) & 0xFFFF)
    if x >= 32768 then return x - 65536 end
    return x
end

--Nozzle/Other
NozzleState = {}
FrontSpeed = {}
Debug = {}
NOZZLE_SWITCH_NORM = {}
NOZZLE_SWITCH_ALT = {}
BlackListActions = {}
REFRESHSOUND = {}
RefreshSoundCheck = {}
BUZZERSOUND = {}
BuzzerSoundCheck = {}
OnPoll = {}
COINSOUND = {}
FluddBind = {}
CurrentSurface = {}
TouchingLava = {}

-- Hover Nozzle Variables
HoverTimer = {}
Hovering = {}
MARIO_HOVER = {}
SoundTimer = {}
MARIO_HOVER_PLAYING = {}
RemoveFalldamge = {}
CanHover = {}

--Rocket Nozzle Variables
CanRocket = {}
RocketCooldown = {}
MARIO_ROCKET = {}
MARIO_ROCKET_LAUNCH = {}

--Turbo Nozzle Variables
CanTurbo = {}
MARIO_TURBO = {}
TurboCoolDown = {}
TurboChargeCheck = {}


function nozzle_update(m)

    local pi = m.playerIndex

    if m.playerIndex == 0 then

    if (m.controller.buttonPressed & U_JPAD) ~= 0 then NozzleState[pi] = 0
    elseif (m.controller.buttonPressed & L_JPAD) ~= 0 then NozzleState[pi] = 1
    elseif (m.controller.buttonPressed & D_JPAD) ~= 0 then NozzleState[pi] = 2
    elseif (m.controller.buttonPressed & R_JPAD) ~= 0 then NozzleState[pi] = 3
    end

end

if m.action == ACT_GROUND_POUND or m.action == ACT_THROWN_FORWARD or m.action == ACT_THROWN_BACKWARD or
        m.action == ACT_HARD_FORWARD_AIR_KB or m.action == ACT_HARD_BACKWARD_AIR_KB or m.action == ACT_BACKWARD_AIR_KB or
        m.action == ACT_FORWARD_AIR_KB or m.action == ACT_BURNING_JUMP or m.action == ACT_BURNING_FALL or 
        m.action == ACT_LAVA_BOOST or m.action == ACT_BURNING_GROUND or m.action == ACT_BACKWARD_GROUND_KB or
        m.action == ACT_FORWARD_GROUND_KB or m.action == ACT_HARD_BACKWARD_GROUND_KB or m.action == ACT_HARD_FORWARD_GROUND_KB or
        m.action == ACT_HARD_BACKWARD_AIR_KB or m.action == ACT_HARD_FORWARD_AIR_KB or m.action == ACT_BURNING_GROUND or m.action == ACT_GROUND_BONK or
        m.action == ACT_LAVA_BOOST_LAND or m.action == ACT_WATER_JUMP or m.action == ACT_DEATH_EXIT or
        m.action == ACT_PULLING_DOOR or m.action == ACT_PUSHING_DOOR or m.action == ACT_FLAG_FLYING or m.action == ACT_IN_CANNON or
        m.action == ACT_PICKING_UP_BOWSER or m.action == ACT_HOLDING_BOWSER or m.action == ACT_RELEASING_BOWSER or
        m.action == ACT_GRABBED or m.action == ACT_PUTTING_ON_CAP or m.action == ACT_TAKING_OFF_CAP or m.action == ACT_SQUISHED or
        m.action == ACT_SHOCKED or m.action == ACT_TELEPORT_FADE_IN or m.action == ACT_TELEPORT_FADE_OUT or m.action == ACT_ENTERING_STAR_DOOR or
        m.action == ACT_UNLOCKING_STAR_DOOR or m.action == ACT_UNLOCKING_KEY_DOOR or m.action == ACT_WARP_DOOR_SPAWN or
        m.action == ACT_EMERGE_FROM_PIPE or m.action == ACT_SPAWN_SPIN_AIRBORNE or m.action == ACT_SPAWN_SPIN_LANDING or
        m.action == ACT_FALLING_DEATH_EXIT or m.action == ACT_SPECIAL_EXIT_AIRBORNE or m.action == ACT_SPECIAL_DEATH_EXIT or
        m.action == ACT_FALLING_EXIT_AIRBORNE or m.action == ACT_SPAWN_NO_SPIN_AIRBORNE or m.action == ACT_BBH_ENTER_JUMP or
        m.action == ACT_BBH_ENTER_SPIN or m.action == ACT_HEAD_STUCK_IN_GROUND or m.action == ACT_BUTT_STUCK_IN_GROUND or
        m.action == ACT_FEET_STUCK_IN_GROUND or m.action == ACT_DISAPPEARED or m.action == ACT_INTRO_CUTSCENE or
        m.action == ACT_STAR_DANCE_EXIT or m.action == ACT_FALL_AFTER_STAR_GRAB or m.action == ACT_STAR_DANCE_NO_EXIT or
        m.action == ACT_EXIT_AIRBORNE or m.action == ACT_EXIT_LAND_SAVE_DIALOG or m.action == ACT_DEATH_ON_STOMACH or
        m.action == ACT_DEATH_ON_BACK or m.action == ACT_SUFFOCATION or m.action == ACT_ELECTROCUTION or
        m.action == ACT_QUICKSAND_DEATH or m.action == ACT_STANDING_DEATH or m.action == ACT_READING_SIGN or
        m.action == ACT_EATEN_BY_BUBBA or m.action == ACT_SHOT_FROM_CANNON or m.action == ACT_BREASTSTROKE or
        m.action == ACT_WATER_IDLE or m.action == ACT_HOLD_WATER_IDLE or m.action == ACT_SWIMMING_END or
        m.action == ACT_FLUTTER_KICK or m.action == ACT_HOLD_BREASTSTROKE or m.action == ACT_HOLD_SWIMMING_END or
        m.action == ACT_HOLD_FLUTTER_KICK or m.action == ACT_WATER_SHELL_SWIMMING or m.action == ACT_WATER_THROW or
        m.action == ACT_WATER_PUNCH or m.action == ACT_WATER_PLUNGE or m.action == ACT_CAUGHT_IN_WHIRLPOOL or
        m.action == ACT_METAL_WATER_STANDING or m.action == ACT_HOLD_METAL_WATER_STANDING or m.action == ACT_METAL_WATER_WALKING or
        m.action == ACT_HOLD_METAL_WATER_WALKING or m.action == ACT_METAL_WATER_FALLING or m.action == ACT_HOLD_METAL_WATER_FALLING or
        m.action == ACT_METAL_WATER_FALL_LAND or m.action == ACT_HOLD_METAL_WATER_FALL_LAND or m.action == ACT_METAL_WATER_JUMP or
        m.action == ACT_HOLD_METAL_WATER_JUMP or m.action == ACT_METAL_WATER_JUMP_LAND or m.action == ACT_HOLD_METAL_WATER_JUMP_LAND or
        m.action == ACT_READING_AUTOMATIC_DIALOG or m.action == ACT_READING_NPC_DIALOG or m.action == ACT_JUMBO_STAR_CUTSCENE or
        m.action == ACT_WAITING_FOR_DIALOG or m.action == ACT_END_PEACH_CUTSCENE or m.action == ACT_CREDITS_CUTSCENE or
        m.action == ACT_END_WAVING_CUTSCENE or m.action == ACT_HOLDING_POLE or m.action == ACT_GRAB_POLE_SLOW or
        m.action == ACT_GRAB_POLE_FAST or m.action == ACT_CLIMBING_POLE or m.action == ACT_TOP_OF_POLE_TRANSITION or
        m.action == ACT_TOP_OF_POLE or m.action == ACT_START_HANGING or m.action == ACT_HANGING or m.action == ACT_HANG_MOVING or
        m.action == ACT_LEDGE_GRAB or m.action == ACT_LEDGE_CLIMB_SLOW_1 or m.action == ACT_LEDGE_CLIMB_SLOW_2 or
        m.action == ACT_LEDGE_CLIMB_DOWN or m.action == ACT_LEDGE_CLIMB_FAST or m.action == ACT_BUBBLED or
        m.action == ACT_TORNADO_TWIRLING or m.action == ACT_PUNCHING or m.action == ACT_HOLD_HEAVY_IDLE or
        m.action == ACT_HOLD_HEAVY_WALKING or m.action == ACT_WATER_ACTION_END
    then BlackListActions[pi] = true
    else BlackListActions[pi] = false
    end

    if m.action == ACT_HOLDING_POLE or m.action == ACT_GRAB_POLE_SLOW or m.action == ACT_GRAB_POLE_FAST or m.action == ACT_CLIMBING_POLE or m.action == ACT_TOP_OF_POLE or m.action == ACT_TOP_OF_POLE_TRANSITION
    then OnPoll[pi] = true
    else OnPoll[pi] = false
    end

end

function hover_update(m)

    local pi = m.playerIndex

    -- Reset variables if its nil
    if SoundTimer[pi] == nil then SoundTimer[pi] = 0 end
    if MARIO_HOVER[pi] == nil then MARIO_HOVER[pi] = audio_sample_load("mario_hover.ogg") end
    if MARIO_HOVER_PLAYING[pi] == nil then MARIO_HOVER_PLAYING[pi] = false end
    if HoverTimer[pi] == nil then HoverTimer[pi] = 0 end
    if Hovering[pi] == nil then Hovering[pi] = false end
    if CanHover[pi] == nil then CanHover[pi] = true end
    if NozzleState[pi] == nil then NozzleState[pi] = 0 end
    if CanRocket[pi] == nil then CanRocket[pi] = true end
    if RocketCooldown[pi] == nil then RocketCooldown[pi] = 0 end
    if FrontSpeed[pi] == nil then FrontSpeed[pi] = 0 end
    if CanTurbo[pi] == nil then CanTurbo[pi] = true end
    if Debug[pi] == nil then Debug[pi] = false end
    if NOZZLE_SWITCH_NORM[pi] == nil then NOZZLE_SWITCH_NORM[pi] = audio_sample_load("nozzle_switch_alt.ogg") end
    if NOZZLE_SWITCH_ALT[pi] == nil then NOZZLE_SWITCH_ALT[pi] = audio_sample_load("nozzle_switch_norm.ogg") end
    if BlackListActions[pi] == nil then BlackListActions[pi] = false end
    if RemoveFalldamge[pi] == nil then RemoveFalldamge[pi] = false end
    if MARIO_ROCKET[pi] == nil then MARIO_ROCKET[pi] = audio_sample_load("fludd_charge.ogg") end
    if MARIO_ROCKET_LAUNCH[pi] == nil then MARIO_ROCKET_LAUNCH[pi] = audio_sample_load("rocketlaunch.ogg") end
    if REFRESHSOUND[pi] == nil then REFRESHSOUND[pi] = audio_sample_load("refreshsound.ogg") end
    if RefreshSoundCheck[pi] == nil then RefreshSoundCheck[pi] = true end
    if BUZZERSOUND[pi] == nil then BUZZERSOUND[pi] = audio_sample_load("buzzer.ogg") end
    if BuzzerSoundCheck[pi] == nil then BuzzerSoundCheck[pi] = true end
    if MARIO_TURBO[pi] == nil then MARIO_TURBO[pi] = audio_sample_load("turbonozzle.ogg") end
    if TurboCoolDown[pi] == nil then TurboCoolDown[pi] = 0 end
    if TurboChargeCheck[pi] == nil then TurboChargeCheck[pi] = true end
    if COINSOUND[pi] == nil then COINSOUND[pi] = audio_sample_load("coin.ogg") end
    if FluddBind[pi] == nil then FluddBind[pi] = L_BUTTON end
    if TouchingLava[pi] == nil then TouchingLava[pi] = false end

    FrontSpeed[pi] = m.forwardVel
    if m.floor ~= nil
    then CurrentSurface[pi] = m.floor.type
    end

    if NozzleState[pi] == 0 and m.playerIndex == 0 then

    if CurrentSurface[pi] == 1 and m.pos.y <= m.floorHeight + 45
    then TouchingLava[pi] = true; m.hurtCounter = m.hurtCounter + 12; set_mario_action(m, ACT_LAVA_BOOST, 0); HoverTimer[pi] = HoverTimer[pi]
    else TouchingLava[pi] = false
    end
        
    --Hover Logic
    if m.vel.y <= 10 and (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] <= 60 and CanHover[pi] == true and BlackListActions[pi] == false and TouchingLava[pi] == false and OnPoll[pi] == false
    then m.vel.y = m.vel.y + 5; set_mario_action(m, ACT_FREEFALL, 0); RemoveFalldamge[pi] = true
    else Hovering[pi] = false; HoverTimer[pi] = HoverTimer[pi]
    end

    if RemoveFalldamge[pi] == true
    then m.peakHeight = m.floorHeight
    end

    --If falling to fast you dont waste all your water going up like 2 inches
    if m.vel.y <= -10 and (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] <= 60 and Hovering[pi] == true
    then m.vel.y = -10
    end

    -- Help get up slopes
    if m.pos.y <= m.floorHeight + 5 and (m.controller.buttonDown & X_BUTTON) ~= 0
    then m.pos.y = m.pos.y + 35
    end

    if Hovering[pi] == true and m.forwardVel >= 55
    then m.forwardVel = m.forwardVel - 1
    end

    --Hover and Sound timer Counter
    if Hovering[pi] == true and HoverTimer[pi] <= 60 and (m.controller.buttonDown & X_BUTTON) ~= 0 and NozzleState[pi] == 0
    then HoverTimer[pi] = HoverTimer[pi] + 1
         SoundTimer[pi] = SoundTimer[pi] + 1
    end

    --Reset most vars if very close to the ground
    if m.pos.y <= m.floorHeight + 45 or m.pos.y <= m.waterLevel then
        Hovering[pi] = false
        HoverTimer[pi] = HoverTimer[pi] - 1
        SoundTimer[pi] = 0
        MARIO_HOVER_PLAYING[pi] = false
        RemoveFalldamge[pi] = false
        CanHover[pi] = false
    end

    --Change Hovering to false from a button press
    if (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] < 60
    then CanHover[pi] = true
         Hovering[pi] = true
    end

    --Reset SoundTimer if these things happen
    if (m.controller.buttonDown & X_BUTTON) == 0 or HoverTimer[pi] >= 61
    then SoundTimer[pi] = 0
         MARIO_HOVER_PLAYING[pi] = false
    end

    --make sure SoundTimer doesnt get to high
    if SoundTimer[pi] >= 65 
    then SoundTimer[pi] = 0
    end

    --Play the hover sound
    if (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] <= 60 and SoundTimer[pi] == 1 and NozzleState[pi] == 0 and MARIO_HOVER_PLAYING[pi] == false
    then audio_sample_play(MARIO_HOVER[pi], m.pos, 3)
         MARIO_HOVER_PLAYING[pi] = true
    end

    -- Stop Hover Sound in general
    if (m.controller.buttonDown & X_BUTTON) == 0 or HoverTimer[pi] >= 60 or m.pos.y <= m.floorHeight + 45 or m.pos.y <= m.waterLevel or BlackListActions[pi] == true
    then audio_sample_stop(MARIO_HOVER[pi])
         MARIO_HOVER_PLAYING[pi] = false
    end

    --Stop Hover Sound if you switch nozzles midair
    if NozzleState[pi] == 0 and (m.controller.buttonPressed & L_JPAD) ~= 0 or (m.controller.buttonPressed & D_JPAD) ~= 0 or (m.controller.buttonPressed & R_JPAD) ~= 0
    then audio_sample_stop(MARIO_HOVER[pi])
         SoundTimer[pi] = 0
         MARIO_HOVER_PLAYING[pi] = false
    end

    --Buzz if you press X and HoverTimer is maxxed
    if (m.controller.buttonPressed & X_BUTTON) ~= 0 and HoverTimer[pi] >= 60
    then play_sound(SOUND_MENU_CAMERA_BUZZ, m.pos)
    end

    if HoverTimer[pi] >= 60
    then BuzzerSoundCheck[pi] = true
    end

    --Buzz is HoverTimer is maxxed out
    if (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] == 59 and BuzzerSoundCheck[pi] == false
    then audio_sample_play(BUZZERSOUND[pi], m.pos, 1.0); BuzzerSoundCheck[pi] = true
    end

    if HoverTimer[pi] == 50
    then BuzzerSoundCheck[pi] = false
    end

    --Particles
    if (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] < 60 and BlackListActions[pi] == false
    then set_mario_particle_flags(m, PARTICLE_SPARKLES, 0)
         set_mario_particle_flags(m, PARTICLE_SNOW, 0)
    end

    --Midair 360 Control (Y Axis)
    if (m.input & INPUT_NONZERO_ANALOG ~= 0) and (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] <= 60 and BlackListActions[pi] == false and Hovering[pi] == true then
        m.faceAngle.y = m.intendedYaw - approach_s32( s16(m.intendedYaw - m.faceAngle.y), 0, 0x800, 0x800)
    end

end --PlayerIndex/NozzleState
end --Function

function action_update(m)

    local pi = m.playerIndex

    if m.playerIndex == 0 and HoverTimer[pi] ~= nil then

    if (m.controller.buttonPressed & X_BUTTON) ~= 0 then

    if BlackListActions[pi] == true
    then play_sound(SOUND_MENU_CAMERA_BUZZ, m.pos)
    end
    end

    if BlackListActions[pi] == true
    then
         CanHover[pi] = false
         Hovering[pi] = false
         CanRocket[pi] = false
    end

    if NozzleState[pi] == 0
    then audio_sample_stop(MARIO_TURBO[pi])
         audio_sample_stop(MARIO_ROCKET[pi])
    end

    if NozzleState[pi] ~= 3
    then TurboCoolDown[pi] = 0
         TurboChargeCheck[pi] = true
    end

    if (m.controller.buttonPressed & U_JPAD) ~= 0 and (m.controller.buttonDown & X_BUTTON) ~= 0
    then audio_sample_stop(MARIO_HOVER[pi])
         audio_sample_play(MARIO_HOVER[pi], m.pos, 3)
    end

        --Check if its in the negs
    if HoverTimer[pi] ~= nil and HoverTimer[pi] <= 0
    then HoverTimer[pi] = 0
    end

    if OnPoll[pi] == true
    then HoverTimer[pi] = HoverTimer[pi] - 1
         Hovering[pi] = false
         CanRocket[pi] = false
         CanHover[pi] = false
    end

    if (m.controller.buttonPressed & U_JPAD) ~= 0 or (m.controller.buttonPressed & L_JPAD) ~= 0 or (m.controller.buttonPressed & D_JPAD) ~= 0 or (m.controller.buttonPressed & R_JPAD) ~= 0
    then
        if math.random(3) == 1 then
            audio_sample_play(NOZZLE_SWITCH_ALT[pi], m.pos, 1.7)
        else
            audio_sample_play(NOZZLE_SWITCH_NORM[pi], m.pos, 1.7)
        end
    end

    if HoverTimer[pi] >= 60
    then Hovering[pi] = false
         CanHover[pi] = false
    end

    if HoverTimer[pi] <= 0 and RefreshSoundCheck[pi] == false
    then audio_sample_play(REFRESHSOUND[pi], m.pos, 1.7); set_mario_particle_flags(m, PARTICLE_MIST_CIRCLE, 0); set_mario_particle_flags(m, PARTICLE_SNOW, 0); RefreshSoundCheck[pi] = true
    end

    if HoverTimer[pi] == 10
    then RefreshSoundCheck[pi] = false
    end

end -- PlayerIndex
end -- Action_update

function rocket_update(m)

    local pi = m.playerIndex

    if NozzleState[pi] == 2 and m.playerIndex == 0 then

    if NozzleState[pi] == 2
    then audio_sample_stop(MARIO_TURBO[pi]); audio_sample_stop(MARIO_HOVER[pi])
    end

    if (m.controller.buttonDown & X_BUTTON) ~= 0 and CanRocket[pi] == true and HoverTimer[pi] <= 0
    then RocketCooldown[pi] = RocketCooldown[pi] + 1
    elseif (m.controller.buttonDown & X_BUTTON) == 0 then RocketCooldown[pi] = 0
    end

    if (m.controller.buttonDown & X_BUTTON) ~= 0 and RocketCooldown[pi] < 30 and CanRocket[pi] == true and HoverTimer[pi] <= 0
    then set_mario_particle_flags(m, PARTICLE_SPARKLES, 0)
    end

    if RocketCooldown[pi] > 30
    then RocketCooldown[pi] = 30
    end

    if m.pos.y <= m.floorHeight + 45 or m.pos.y <= m.waterLevel then
        HoverTimer[pi] = HoverTimer[pi] - 1
    end

    if HoverTimer[pi] <= 0
    then CanRocket[pi] = true
    end

    if RocketCooldown[pi] == 1 and HoverTimer[pi] <= 0 and (m.controller.buttonDown & X_BUTTON) ~= 0
    then audio_sample_play(MARIO_ROCKET[pi], m.pos, 1.7)
    end

    if (m.controller.buttonDown & X_BUTTON) == 0 or (m.controller.buttonPressed & U_JPAD) ~= 0 or (m.controller.buttonPressed & L_JPAD) ~= 0 or (m.controller.buttonPressed & R_JPAD) ~= 0
    then audio_sample_stop(MARIO_ROCKET[pi])
    end

    if (m.controller.buttonDown & X_BUTTON) ~= 0 and CanRocket[pi] == true and HoverTimer[pi] <= 0 and RocketCooldown[pi] == 30
    then m.vel.y = 0
    end

    if (m.controller.buttonDown & X_BUTTON) ~= 0 and m.vel.y == 0 and CanRocket[pi] == true and NozzleState[pi] == 2 and HoverTimer[pi] <= 0 and RocketCooldown[pi] == 30 and BlackListActions[pi] == false then
        m.vel.y = m.vel.y + 110
        m.action = ACT_FREEFALL
        CanRocket[pi] = false
        HoverTimer[pi] = 60
        RocketCooldown[pi] = 0
        audio_sample_play(MARIO_ROCKET_LAUNCH[pi], m.pos, 1.7)
        RemoveFalldamge[pi] = true
    end

    if CanRocket[pi] == false
    then m.peakHeight = m.floorHeight
    end

    if (m.input & INPUT_NONZERO_ANALOG ~= 0) and m.action == ACT_FREEFALL and CanRocket[pi] == false and m.vel.y > 0 then
        m.faceAngle.y = m.intendedYaw - approach_s32( s16(m.intendedYaw - m.faceAngle.y), 0, 0x800, 0x800)
    end

    if HoverTimer[pi] >= 60 and NozzleState[pi] == 2 and m.vel.y >= 0 and BlackListActions[pi] == false and m.action ~= ACT_WALL_KICK_AIR
    then set_mario_particle_flags(m, PARTICLE_MIST_CIRCLE, 0)
         set_mario_particle_flags(m, PARTICLE_SNOW, 0)
    end

    if (m.controller.buttonPressed & X_BUTTON) ~= 0 and HoverTimer[pi] > 0
    then play_sound(SOUND_MENU_CAMERA_BUZZ, m.pos)
    end

    end -- playerIndex

end --Rocket update

function turbo_update(m)

    local pi = m.playerIndex

    if NozzleState[pi] == 3 then

    if m.playerIndex == 0 then

    if (m.controller.buttonDown & X_BUTTON) ~= 0 and CanTurbo[pi] == true
    then TurboCoolDown[pi] = TurboCoolDown[pi] + 1
    elseif (m.controller.buttonDown & X_BUTTON) == 0 or HoverTimer[pi] >= 60 or (m.controller.buttonPressed & U_JPAD) ~= 0 or (m.controller.buttonPressed & L_JPAD) ~= 0 or (m.controller.buttonPressed & D_JPAD) ~= 0 then TurboCoolDown[pi] = 0
    end
    
    if BlackListActions[pi] == true
    then TurboCoolDown[pi] = 0; SoundTimer[pi] = 0; audio_sample_stop(MARIO_TURBO[pi])
    end

    if TurboCoolDown[pi] > 20
    then TurboCoolDown[pi] = 20
    end

    if (m.controller.buttonDown & X_BUTTON) ~= 0 and TurboChargeCheck[pi] == true and CanTurbo[pi] == true and BlackListActions[pi] == false
    then audio_sample_play(MARIO_ROCKET[pi], m.pos, 1.7); TurboChargeCheck[pi] = false
    elseif (m.controller.buttonDown & X_BUTTON) == 0 or CanTurbo[pi] == false or BlackListActions[pi] == true then TurboChargeCheck[pi] = true; audio_sample_stop(MARIO_ROCKET[pi])
    end

    if (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] < 60 and CanTurbo[pi] == true and BlackListActions[pi] == false and OnPoll[pi] == false and TurboCoolDown[pi] == 20
    then m.forwardVel = m.forwardVel + 15
         set_mario_particle_flags(m, PARTICLE_SPARKLES, 0)
         set_mario_particle_flags(m, PARTICLE_SNOW, 0)
         SoundTimer[pi] = SoundTimer[pi] + 1

    if m.pos.y <= m.floorHeight and CanTurbo[pi] == true and BlackListActions[pi] == false
    then set_mario_action(m, ACT_WALKING, 0)
    end
    end

    if (m.controller.buttonDown & X_BUTTON) == 0 or SoundTimer[pi] >= 65
    then SoundTimer[pi] = 0
    end

    if SoundTimer[pi] == 1 and (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] < 60 and CanTurbo[pi] == true and BlackListActions[pi] == false and OnPoll[pi] == false
    then audio_sample_play(MARIO_TURBO[pi], m.pos, 2.0)
    end

    if (m.controller.buttonDown & X_BUTTON) == 0 or HoverTimer[pi] >= 60 or SoundTimer[pi] >= 65
    then audio_sample_stop(MARIO_TURBO[pi])
    end

    if HoverTimer[pi] >= 60
    then BuzzerSoundCheck[pi] = true
    end

    --Buzz is HoverTimer is maxxed out
    if (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] == 59 and BuzzerSoundCheck[pi] == false
    then audio_sample_play(BUZZERSOUND[pi], m.pos, 1.0); BuzzerSoundCheck[pi] = true; SoundTimer[pi] = 0
    end

    if HoverTimer[pi] == 50
    then BuzzerSoundCheck[pi] = false
    end

    if (m.controller.buttonPressed & X_BUTTON) ~= 0 and CanTurbo[pi] == false
    then play_sound(SOUND_MENU_CAMERA_BUZZ, m.pos)
    end

    end -- PlayerIndex

    if m.forwardVel > 100 and (m.controller.buttonDown & X_BUTTON) ~= 0 then m.forwardVel = 100 end

    if (m.controller.buttonDown & X_BUTTON) == 0 and m.forwardVel > 50 then m.forwardVel = m.forwardVel - 2 end

    if m.pos.y <= m.floorHeight + 20 and (m.controller.buttonDown & X_BUTTON) ~= 0 and CanTurbo[pi] == true and BlackListActions[pi] == false and TurboCoolDown[pi] == 20
    then HoverTimer[pi] = HoverTimer[pi] + 2
    elseif m.pos.y > m.floorHeight + 20 and (m.controller.buttonDown & X_BUTTON) ~= 0 and CanTurbo[pi] == true and BlackListActions[pi] == false and OnPoll[pi] == false and TurboCoolDown[pi] == 20 then HoverTimer[pi] = HoverTimer[pi] + 1
    end

    if m.pos.y <= m.floorHeight + 45 or m.pos.y <= m.waterLevel then
        HoverTimer[pi] = HoverTimer[pi] - 1
    end

    if m.pos.y <= m.floorHeight or m.pos.y <= m.waterLevel
    then RemoveFalldamge[pi] = false
    end

    if HoverTimer[pi] > 60 then HoverTimer[pi] = 60 end

    if HoverTimer[pi] >= 60
    then CanTurbo[pi] = false
    elseif HoverTimer[pi] <= 25 then CanTurbo[pi] = true
    end

    if m.pos.y <= m.waterLevel + 100 and (m.controller.buttonDown & X_BUTTON) ~= 0 and CanTurbo[pi] == true and HoverTimer[pi] < 60 and BlackListActions[pi] == false and TurboCoolDown[pi] == 20
    then m.pos.y = m.waterLevel + 25
         set_mario_action(m, ACT_FREEFALL, 0)
         m.faceAngle.y = m.intendedYaw - approach_s32( s16(m.intendedYaw - m.faceAngle.y), 0, 0x800, 0x800)
         m.vel.y = 0
         set_mario_particle_flags(m, PARTICLE_MIST_CIRCLE, 0)

    end
    
end -- NozzleState
end -- turbo_update

function BroadCastTurbo()

    if (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] < 60 and CanTurbo[pi] == true and BlackListActions[pi] == false and OnPoll[pi] == false and TurboCoolDown[pi] == 20 and NozzleState[pi] == 3 and m.pos.y <= m.floorHeight
    then m.vel.x = m.vel.x * 2
         m.vel.z = m.vel.z * 2
    end

    if (m.controller.buttonDown & X_BUTTON) ~= 0 and HoverTimer[pi] < 60 and CanTurbo[pi] == true and BlackListActions[pi] == false and OnPoll[pi] == false and TurboCoolDown[pi] == 20 and NozzleState[pi] == 3 and m.pos.y > m.floorHeight
    then m.vel.x = m.vel.x * 1.3
         m.vel.z = m.vel.z * 1.3
    end

    if m.vel.x > 100
    then m.vel.x = 100
    end

    if m.vel.z > 100
    then m.vel.z = 100
    end

end

function squirt_update(m)

    local pi = m.playerIndex

    if NozzleState[pi] == 1 then

    if m.pos.y <= m.floorHeight + 45 or m.pos.y <= m.waterLevel
    then HoverTimer[pi] = HoverTimer[pi] - 1
    end

end
end

function on_hud_render()

    djui_hud_set_resolution(RESOLUTION_DJUI)
    djui_hud_set_font(FONT_MENU)
    djui_hud_set_color(255, 255, 255, 255)

    -- get current player index safely
    local playerIndex = gMarioStates[0] and gMarioStates[0].playerIndex or 0


    -- print it on screen

    if Debug[playerIndex] == true then

    djui_hud_print_text("HoverTimer: " .. tostring(HoverTimer[playerIndex]), 10, 20, 0.7)
    djui_hud_print_text("Hovering: " .. tostring(Hovering[playerIndex]), 10, 50, 0.7)
    djui_hud_print_text("CanRocket: " .. tostring(CanRocket[playerIndex]), 10, 80, 0.7)
    djui_hud_print_text("NozzleState: " .. tostring(NozzleState[playerIndex]), 10, 110, 0.7)
    djui_hud_print_text("SoundTimer: " .. tostring(SoundTimer[playerIndex]), 10, 140, 0.7)
    djui_hud_print_text("forwardVel: " .. tostring(FrontSpeed[playerIndex]), 10, 170, 0.7)
    djui_hud_print_text("CanTurbo: " .. tostring(CanTurbo[playerIndex]), 10, 200, 0.7)
    djui_hud_print_text("BlackListActions: " .. tostring(BlackListActions[playerIndex]), 10, 230, 0.7)
    djui_hud_print_text("RemoveFalldamge: " .. tostring(RemoveFalldamge[playerIndex]), 10, 260, 0.7)
    djui_hud_print_text("CanHover: " .. tostring(CanHover[playerIndex]), 10, 290, 0.7)
    djui_hud_print_text("RocketCooldown: " .. tostring(RocketCooldown[playerIndex]), 10, 320, 0.7)
    djui_hud_print_text("RefreshSoundCheck: " .. tostring(RefreshSoundCheck[playerIndex]), 10, 350, 0.7)
    djui_hud_print_text("BuzzerSoundCheck: " .. tostring(BuzzerSoundCheck[playerIndex]), 10, 380, 0.7)
    djui_hud_print_text("TurboCoolDown: " .. tostring(TurboCoolDown[playerIndex]), 10, 410, 0.7)
    djui_hud_print_text("TurboChargeCheck: " .. tostring(TurboChargeCheck[playerIndex]), 10, 440, 0.7)
    djui_hud_print_text("CurrentSurface: " .. tostring(CurrentSurface[playerIndex]), 10, 470, 0.7)
    djui_hud_print_text("TouchingLava: " .. tostring(TouchingLava[playerIndex]), 10, 500, 0.7)
    djui_hud_print_text("OnPoll: " .. tostring(OnPoll[playerIndex]), 10, 530, 0.7)

end

    if NozzleState[pi] == 1
    then djui_hud_print_text("This Nozzle Isn't Done Yet", 370, 20, 1.5)
    end
end

function DebugToggle(msg)

    if msg == "true" then
        djui_chat_message_create("Debug enabled")
        Debug[pi] = true
        return true
    elseif msg == "false" then
        djui_chat_message_create("Debug disabled")
        Debug[pi] = false
        return true
    end
    return false
end

function RendersCommand(msg)

    if msg == "true" then
        djui_chat_message_create("Renders Enabled")
        DisableRender[pi] = false
        return true
    elseif msg == "false" then
        djui_chat_message_create("Renders Disabled")
        DisableRender[pi] = true
        return true
    end
    return false
end


hook_chat_command("fludd debug", "\\#ff0\\[true|false] turn Debug on or off", DebugToggle)
hook_chat_command("fludd renders", "\\#ff0\\[true|false] turn image renders on or off", RendersCommand)
hook_event(HOOK_ON_HUD_RENDER, on_hud_render)
hook_event(HOOK_MARIO_UPDATE, action_update)
hook_event(HOOK_MARIO_UPDATE, hover_update)
hook_event(HOOK_MARIO_UPDATE, nozzle_update)
hook_event(HOOK_MARIO_UPDATE, rocket_update)
hook_event(HOOK_MARIO_UPDATE, turbo_update)
hook_event(HOOK_MARIO_UPDATE, squirt_update)
hook_event(HOOK_BEFORE_PHYS_STEP, BroadCastTurbo)
